<?php
require_once 'header.php';

if(!$usersObject->ID()) {
	header("Location: /");
	exit;
}

$month = date("M");
$year= date("Y");

if(isset($_GET['m'])) $month = (string) $db->escape(trim(strip_tags($_GET['m'])));
if(strlen($month) != 3) die("Incorrect month");

if(isset($_GET['y'])) $year = $db->escape(trim(strip_tags(intval($_GET['y']))));
if(strlen($year) != 4) die("Incorrect year" . $year);

?>

<div class="container ctwhite">

	<h1><?=translate('affiliates')?></h1>
	
	
	<?=translate('affiliate_url_desc') ?> 
	
	<a href="<?=SITE?>/?id=<?=$usersObject->ID()?>"><?=SITE?>/?id=<?=$usersObject->ID()?></a> 
	

</div>

<div class="container ctwhite" style="margin-top:20px;">

	<h1><?=translate('affiliates_stats')?></h1>
	
	<?php
			$months = array('Jan' => 'Jan', 'Feb' => 'Feb',
                                'Mar' => 'Mar', 'Apr' => 'Apr', 
                                'May' => 'May', 'Jun' => 'Jun',
                                'Jul' => 'Jul', 'Aug' => 'Aug',
                                'Sep' => 'Sep', 'Oct' => 'Oct',
                                'Nov' => 'Nov', 'Dec' => 'Dec');
			
			?>
		   <form method="GET" action="" class="form-horizontal">
            <select name="m">
                <?php
                foreach($months as $month_select) {
                    if($month_select == date("M")) {
                        print '<option value="'.$month_select.'" selected="">'.$month_select.'</option>';
                    }else{
                        print '<option value="'.$month_select.'">'.$month_select.'</option>';
                    }
                    print "\n";
                }
                              
                ?>
            </select>
            <select name="y">
                <?php
                for($years = 2012; $years <= date("Y"); $years++) {
                    if($years == date("Y")) {
                        print '<option value="'.$years.'" selected="">'.$years.'</option>';
                    }else{
                        print '<option value="'.$years.'">'.$years.'</option>';
                    } 
                }
                ?>
            </select>
            <input type="submit" name="sbdate" value="Go" class="btn" style="margin-top:5px;"/>
        </form>
        
        <?php
        $earnings_total = $db->get_row("SELECT affID, SUM(amount) AS total, status FROM affiliates, advertisers  
        									WHERE affID = '".$usersObject->ID()."' 
        									AND advertisers.status != 'Pending' 
        									AND affiliates.cID = advertisers.advID 
        									AND month = '$month' AND year = '$year'");
		
													
		if(count($earnings_total) and $earnings_total->total > 0) {
			print ('<h4>'.translate('total').' : $'. number_format($earnings_total->total,5) . '</h4>'); 
		
		$earnings = $db->get_results("SELECT affID, status, title, exact_time, amount, email 
											FROM affiliates, advertisers, users  
        									WHERE affID = '".$usersObject->ID()."' 
        									AND advertisers.status != 'Pending' 
        									AND affiliates.cID = advertisers.advID
        									AND advertisers.user = users.userID 
        									AND month = '$month' AND year = '$year'");
												
        ?>
        
        <table class="table table-bordered table-striped table-hover">
        	<thead>
        		<tr>
        			<th><?=translate('user')?></th>
        			<th><?=translate('campaign')?></th>
        			<th><?=translate('date')?></th>
        			<th><?=translate('earnings')?></th>
        		</tr>
        	</thead>
        	<tbody>
        		<?php
        		foreach ($earnings as $e) {
					print "<tr>
								<td>$e->email</td>
								<td>$e->title</td>
								<td>".date("jS F Y", $e->exact_time)."</td>
								<td>$".$e->amount."</td>
							</tr>
							";
				}
        		?>
        	</tbody>
        </table>
        
        <?php 
        }else{ 
        	print translate('no_earnings');	
        }
        ?>	
	
</div>

<?php
require_once 'footer.php';
?>